<?php

namespace App\Models\Students;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getStudents()
    {
        return $this->belongsToMany('App\Models\Students\Student', 'student_group')->withPivot('access','usage');
    }

    public function getOwnerStudent()
    {
        return $this->belongsTo('App\Models\Students\Student', 'owner_student_id');
    }

    public function getOwnerUser()
    {
        return $this->belongsTo('App\Models\Orgs\User', 'owner_user_id');
    }

}